package com.ejie.aa94a.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.stereotype.Component;

/**
 * 
 * @author GFI-Norte
 * 
 */
@Component(value = "baseProperties")
public class PropertiesUtil extends PropertyPlaceholderConfigurer {

	private static final Logger logger = LoggerFactory
			.getLogger(PropertiesUtil.class);

	private static Map<String, String> propertiesMap;

	@Override
	protected void processProperties(
			ConfigurableListableBeanFactory beanFactory, Properties props)
			throws BeansException {
		super.processProperties(beanFactory, props);
		PropertiesUtil.logger.info("[processProperties - Inicio]");
		PropertiesUtil.propertiesMap = new HashMap<String, String>();

		for (Object key : props.keySet()) {
			String keyStr = key.toString();

			PropertiesUtil.propertiesMap.put(keyStr,
					this.resolvePlaceholder(keyStr, props));
		}
		// Realiza la configuración del Sistema
		UtilConfiguracion.inicializaConfiguracion();
		PropertiesUtil.logger.info("[processProperties - Inicio]");
	}

	/**
	 * 
	 * @param name
	 *            String
	 * @return String
	 */
	public static String getProperty(String name) {
		return PropertiesUtil.propertiesMap.get(name);
	}

}
